<?php
/*

Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)



This file is part of DFTK.

DFTK is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DFTK is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DFTK; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/**
 * @package		dftk
 * @author		Duck <duck@DuckCorp.org>
 * @author		Rtp <rtp@rtp-net.org>
 * @copyright	Copyright (c)2003 DuckCorp(tm) and RtpNet(tm)
 * @license		http://www.gnu.org/licenses/gpl.html					GNU General Public License
 * @version		0.4.0
 */


/**
 * DFTK Output Base Class
 *
 * @package		dftk
 * @subpackage	dftk-output
 * @author		Duck <duck@DuckCorp.org>
 *
 * @access		public
 * @abstract
 */
class DftkOutput
{
	/**
	 * Trace Manager
	 *
	 * @access		private
	 * @var			string
	 */
	var	$_tracemgr;

	/**
	 * Header
	 *
	 * @access		private
	 * @var			string
	 */
	var $_header;

	/**
	 * Content
	 *
	 * @access		private
	 * @var			string
	 */
	var $_content;

	/**
	 * Footer
	 *
	 * @access		private
	 * @var			string
	 */
	var $_footer;

	/**
	 * Constructor
	 *
	 * @access		public
	 * @param		object DftkDaTraceManager	&$tracemgr			Language Manager
	 */
	function DftkOutput(&$tracemgr)
	{
		$this->_tracemgr =& $tracemgr;

		if (!$this->_tracemgr->is_module("DFTK-OUTPUT"))
			$this->_tracemgr->register_events("DFTK-OUTPUT",DFTK_ROOT_PATH."/output/traces/");
		
		$this->_header = "";
		$this->_content = "";
		$this->_footer = "";
		
		register_shutdown_function(array(&$this, "_DftkOutput"));
	}

	/**
	 * Destructor
	 *
	 * @access		private
	 */
	function _DftkOutput()
	{
	}

	/**
	 * Set Header
	 *
	 * @access		public
	 * @param		string						$header				Header
	 * @return		object DftkDaTrace			$r					Trace
	 */
	function &set_header($header)
	{
		$r =& $this->_tracemgr->create_trace();

		$this->_header = $header;

		return $r;
	}

	/**
	 * Set Footer
	 *
	 * @access		public
	 * @param		string						$footer				Footer
	 * @return		object DftkDaTrace			$r					Trace
	 */
	function &set_footer($footer)
	{
		$r =& $this->_tracemgr->create_trace();

		$this->_footer = $footer;

		return $r;
	}

	/**
	 * Add Content
	 *
	 * @access		public
	 * @param		string						$str				Content to add
	 * @return		object DftkDaTrace			$r					Trace
	 */
	function &add_content($str)
	{
		$r =& $this->_tracemgr->create_trace();

		$this->_content.= $str;

		return $r;
	}

	/**
	 * Clear Content
	 *
	 * @access		public
	 * @return		object DftkDaTrace			$r					Trace
	 */
	function &clear_content()
	{
		$r =& $this->_tracemgr->create_trace();

		$this->_content = "";

		return $r;
	}

	/**
	 * Flush output (MUST BE OVERLOADED)
	 *
	 * @access		public
	 * @return		object DftkDaTrace			$r					Trace
	 */
	function &flush_output()
	{
		return $this->clear_content();
	}
}

?>
